<?php
// Set the page title for the header to use
$page_title = 'Privacy & Cookie Policy | Genowa Delivery Unit';

// Include the website header
require_once 'includes/header.php';
?>

<div class="bg-brand-blue dark:bg-dark-card py-16 sm:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h1 class="text-4xl lg:text-5xl font-extrabold text-white">
            Privacy & Cookie Policy
        </h1>
        <p class="mt-4 text-lg text-gray-300">
            Your trust is important to us. Last Updated: July 27, 2025
        </p>
    </div>
</div>

<div class="py-16 sm:py-24 bg-brand-light-gray dark:bg-dark-bg">
    <div class="container mx-auto max-w-4xl px-4 sm:px-6 lg:px-8">
        <div class="bg-white dark:bg-dark-card rounded-lg shadow-lg p-8 lg:p-12 prose prose-lg prose-blue dark:prose-invert max-w-none">
            
            <p class="lead">The Genowa Delivery Unit ("we," "us," or "our"), is committed to protecting your privacy. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you visit our website, genowa.co.ke.</p>

            <h2 class="text-3xl font-bold text-brand-blue dark:text-gray-200 mt-10 pb-2 border-b-2 border-brand-orange">Information We Collect</h2>
            <p>We may collect information about you in a variety of ways. The information we may collect on the site includes:</p>

            <h3>Personal Data</h3>
            <p>Personally identifiable information, such as your <strong>name, email address, and phone number</strong>, that you voluntarily give to us when you fill out a contact form, the "Join the Movement" form, or choose to participate in other interactive features of the site.</p>
            
            <h3>Usage Data</h3>
            <p>Information our servers automatically collect when you access the site, such as your IP address, your browser type, your operating system, your access times, and the pages you have viewed directly before and after accessing the site.</p>

            <h3>Cookies and Tracking Technologies</h3>
            <p>We use cookies to help customize the site and improve your experience. For example, we use a cookie to remember your selected constituency so we can show you relevant projects. More information is in the Cookie Policy section below.</p>
            
            <h2 class="text-3xl font-bold text-brand-blue dark:text-gray-200 mt-10 pb-2 border-b-2 border-brand-orange">How We Use Your Information</h2>
            <p>Having accurate information about you permits us to provide you with a smooth, efficient, and customized experience. Specifically, we may use information collected about you via the site to:</p>
            <ul class="space-y-2 list-disc list-inside marker:text-brand-orange">
                <li>Provide and maintain our website and its features.</li>
                <li>Respond to your comments, inquiries, and provide user support.</li>
                <li>Personalize your website experience by showing you projects relevant to your selected constituency.</li>
                <li><strong>Send you periodic emails, SMS messages, or WhatsApp messages containing project updates, follow-ups, and other promotional materials related to the Genowa Delivery Unit's initiatives.</strong></li>
                <li>Monitor and analyze usage and trends to improve our website and services.</li>
            </ul>

            <h2 class="text-3xl font-bold text-brand-blue dark:text-gray-200 mt-10 pb-2 border-b-2 border-brand-orange">Data Sharing and Disclosure</h2>
            <p>We are committed to keeping your data confidential. <strong>We do not sell, trade, or otherwise transfer your personally identifiable information to outside parties.</strong></p>
            <p>We may disclose your information if we are required to do so by law or in the good faith belief that such action is necessary to comply with a legal obligation, protect and defend our rights or property, or protect the personal safety of users of the site or the public.</p>
            
            <h2 class="text-3xl font-bold text-brand-blue dark:text-gray-200 mt-10 pb-2 border-b-2 border-brand-orange">Data Security</h2>
            <p>We use administrative, technical, and physical security measures to help protect your personal information. While we have taken reasonable steps to secure the personal information you provide to us, please be aware that despite our efforts, no security measures are perfect or impenetrable.</p>

            <h2 class="text-3xl font-bold text-brand-blue dark:text-gray-200 mt-10 pb-2 border-b-2 border-brand-orange">Your Data Rights</h2>
            <p>You have certain rights regarding your personal data. You have the right to:</p>
            <ul class="space-y-2 list-disc list-inside marker:text-brand-orange">
                <li><strong>Access</strong> – You can request a copy of the personal data we hold about you.</li>
                <li><strong>Rectification</strong> – You can request that we correct any inaccurate or incomplete data.</li>
                <li><strong>Opt-Out</strong> – You can opt-out of receiving future promotional communications from us at any time by following the unsubscribe instructions in those communications or by contacting us directly.</li>
            </ul>
            <p>To exercise any of these rights, please contact us at <a href="mailto:hello@genowa.co.ke" class="text-brand-blue hover:text-brand-orange font-semibold underline">hello@genowa.co.ke</a>.</p>

            <h2 class="text-3xl font-bold text-brand-blue dark:text-gray-200 mt-10 pb-2 border-b-2 border-brand-orange">Cookie Policy</h2>
            <h3>What Are Cookies?</h3>
            <p>A cookie is a small text file stored on your computer or mobile device when you visit a website. It allows the site to remember your actions and preferences (such as your chosen constituency) over a period of time.</p>

            <h3>How We Use Cookies</h3>
            <ul class="space-y-2 list-disc list-inside marker:text-brand-orange">
                <li><strong>Strictly Necessary Cookies:</strong> These are essential for the website to function. We use a cookie to remember your chosen constituency preference.</li>
                <li><strong>Performance and Analytics Cookies:</strong> We may use cookies to collect information about how you interact with our website to help us improve it.</li>
            </ul>

            <h3>Managing Cookies</h3>
            <p>You can control and/or delete cookies as you wish. Most web browsers allow you to manage your cookie preferences through the browser settings. However, please note that if you disable cookies, some features of our website may not function properly.</p>
            
            <h2 class="text-3xl font-bold text-brand-blue dark:text-gray-200 mt-10 pb-2 border-b-2 border-brand-orange">Contact Us</h2>
            <p>If you have any questions or concerns about this Privacy & Cookie Policy, please contact us at:</p>
            <p>
                <strong>Genowa Delivery Unit</strong><br>
                Homa Bay County Government<br>
                Email: <a href="mailto:hello@genowa.co.ke" class="text-brand-blue hover:text-brand-orange font-semibold underline">hello@genowa.co.ke</a>
            </p>
            
        </div>
    </div>
</div>

<?php
// Include the website footer
require_once 'includes/footer.php';
?>