<?php
// FILE: public_html/includes/header.php

// 1. DATA INITIALIZATION & HELPERS
if (!isset($pdo)) { require_once 'db_connect.php'; }

if (!function_exists('e')) {
    function e($string) { return htmlspecialchars((string)$string, ENT_QUOTES, 'UTF-8'); }
}

// 2. CONTROLLER LOGIC (Ideally move to a separate init.php)
$current_page = basename($_SERVER['SCRIPT_NAME']);
$my_constituency_id = filter_input(INPUT_COOKIE, 'my_constituency_id', FILTER_VALIDATE_INT);
$my_constituency_name = '';

// Fetch User's Constituency
if ($my_constituency_id) {
    try {
        $stmt = $pdo->prepare("SELECT name FROM constituencies WHERE id = ? LIMIT 1");
        $stmt->execute([$my_constituency_id]);
        $my_constituency_name = $stmt->fetchColumn() ?: '';
    } catch (PDOException $e) {
        error_log('HEADER: Constituency name fetch failed: ' . $e->getMessage());
    }
}

// Fetch All Constituencies for Modal
$all_constituencies_for_modal = [];
try {
    $all_constituencies_for_modal = $pdo->query("SELECT id, name FROM constituencies ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    error_log('HEADER: Modal constituency list fetch failed: ' . $e->getMessage());
}

// 3. SEO & META CONFIGURATION
$default_title = "Genowa Delivery Unit | Showcasing the endless potential of Homa Bay";
$final_title = isset($page_title) ? e($page_title) : $default_title;
$default_description = "Official portal for the Homa Bay County Genowa Delivery Unit, tracking development projects under Governor Gladys Wanga.";
$meta_description = $meta_description ?? $default_description;
$canonical_url = $canonical_url ?? 'https://www.genowa.co.ke/';
$og_url = $og_url ?? $canonical_url;
$og_image = $og_image ?? 'https://www.genowa.co.ke/admin/assets/genowa.png';
$twitter_image = $twitter_image ?? $og_image;
$og_description = $og_description ?? $meta_description;
$twitter_description = $twitter_description ?? $meta_description;
$meta_keywords = "Homa Bay development, Gladys Wanga, Genowa Delivery Unit, projects in Homa Bay, Homa Bay County";

// 4. NAVIGATION CONFIGURATION
$nav_items = [
    ['href' => 'index.php', 'label' => 'Home', 'pages' => ['index.php']],
    ['href' => 'projects.php', 'label' => 'All Projects', 'pages' => ['projects.php']],
    ['href' => 'news.php', 'label' => 'News', 'pages' => ['news.php', 'article.php']],
    ['href' => 'map.php', 'label' => 'Project Map', 'pages' => ['map.php']],
    ['href' => 'data_dashboard.php', 'label' => 'Data Dashboard', 'pages' => ['data_dashboard.php']]
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <title><?php echo $final_title; ?></title>
    <meta name="description" content="<?php echo e($meta_description); ?>">
    <meta name="keywords" content="<?php echo e($meta_keywords); ?>">
    <meta name="author" content="Homa Bay County Government">
    <link rel="canonical" href="<?php echo e($canonical_url); ?>" />
    
    <meta property="og:title" content="<?php echo $final_title; ?>" />
    <meta property="og:description" content="<?php echo e($og_description); ?>" />
    <meta property="og:type" content="article" />
    <meta property="og:url" content="<?php echo e($og_url); ?>" />
    <meta property="og:image" content="<?php echo e($og_image); ?>" />
    <meta property="og:site_name" content="Genowa Delivery Unit" />
    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo $final_title; ?>">
    <meta name="twitter:description" content="<?php echo e($twitter_description); ?>">
    <meta name="twitter:image" content="<?php echo e($twitter_image); ?>">
    
    <link rel="icon" href="/favicon.ico" type="image/x-icon">
    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/admin/assets/css/custom.css">

    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "GovernmentOrganization",
      "name": "Genowa Delivery Unit",
      "url": "https://www.genowa.co.ke",
      "logo": "https://www.genowa.co.ke/admin/assets/hbc_logo.png",
      "contactPoint": {
        "@type": "ContactPoint",
        "telephone": "+254-000-000-000",
        "contactType": "Customer Service",
        "email": "hello@genowa.co.ke"
      }
    }
    </script>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
    tailwind.config = {
        darkMode: 'class',
        theme: {
            extend: {
                colors: {
                    'brand-blue': '#1E3A8A', 
                    'brand-orange': '#F97316',
                    'brand-purple': '#6D28D9', 
                    'brand-light-gray': '#F3F4F6',
                    'dark-bg': '#111827', 
                    'dark-card': '#1F2937'
                }
            }
        }
    }
    </script>
    
    <script>
    if (localStorage.getItem('theme') === 'dark') {
      document.documentElement.classList.add('dark');
    }
    </script>

    <script src="/admin/assets/js/main.js" defer></script>
</head>
<body class="bg-brand-light-gray dark:bg-dark-bg text-gray-800 dark:text-gray-200 transition-colors duration-300">

<a href="#main-content" class="skip-link">Skip to main content</a>

<header class="bg-white dark:bg-dark-card sticky top-0 z-50 transition-shadow duration-300">
    <nav class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex items-center justify-between h-20">
            <div class="flex-shrink-0">
                <a href="index.php" class="flex items-center space-x-3" aria-label="Genowa Delivery Unit Home">
                    <img src="/admin/assets/hbc_logo.png" class="h-12 w-auto" alt="Homa Bay County Logo" loading="lazy">
                    <div class="h-10 w-px bg-gray-300 dark:bg-gray-600"></div>
                    <div>
                        <span class="font-extrabold text-xl text-brand-blue dark:text-white">GENOWA</span>
                        <span class="block font-semibold text-xs text-brand-orange -mt-1">DELIVERY UNIT</span>
                    </div>
                </a>
            </div>

            <div class="hidden md:flex items-center space-x-6">
                <?php foreach ($nav_items as $item):
                    $isActive = in_array($current_page, $item['pages']); ?>
                    <a href="<?php echo e($item['href']); ?>" class="font-semibold transition-colors duration-300 <?php echo $isActive ? 'nav-link-active' : 'text-gray-600 dark:text-gray-300 hover:text-brand-orange'; ?>">
                        <?php echo e($item['label']); ?>
                    </a>
                <?php endforeach; ?>
                
                <button id="set-location-btn" class="text-sm font-semibold text-gray-600 dark:text-gray-300 hover:text-brand-orange dark:hover:text-brand-orange flex items-center gap-x-1" type="button">
                    <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M15 10.5a3 3 0 11-6 0 3 3 0 016 0z" /><path stroke-linecap="round" stroke-linejoin="round" d="M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1115 0z" /></svg>
                    <span>My Constituency</span>
                    <span class="my-constituency-badge <?php echo $my_constituency_name ? '' : 'hidden'; ?>" aria-live="polite"><?php echo e($my_constituency_name); ?></span>
                </button>

                <button class="theme-toggle-btn p-2 rounded-full hover:bg-gray-100 dark:hover:bg-gray-700" aria-label="Toggle Light or Dark Theme" type="button">
                    <svg class="theme-toggle-dark-icon hidden h-5 w-5" fill="currentColor" viewBox="0 0 20 20"><path d="M17.293 13.293A8 8 0 016.707 2.707a8.001 8.001 0 1010.586 10.586z"></path></svg>
                    <svg class="theme-toggle-light-icon hidden h-5 w-5" fill="currentColor" viewBox="0 0 20 20"><path d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l.707.707a1 1 0 001.414-1.414l-.707-.707a1 1 0 00-1.414 1.414zm2.121-3.536a1 1 0 010-1.414l.707-.707a1 1 0 111.414 1.414l-.707-.707a1 1 0 01-1.414 0zM10 16a1 1 0 011 1v1a1 1 0 11-2 0v-1a1 1 0 011-1zM4.95 14.536a1 1 0 010-1.414l-.707-.707a1 1 0 00-1.414 1.414l.707.707a1 1 0 001.414 0zm-2.121-3.536a1 1 0 011.414 0l.707.707a1 1 0 11-1.414 1.414l-.707-.707a1 1 0 010-1.414zM10 4a1 1 0 01-1-1V2a1 1 0 112 0v-1a1 1 0 01-1 1z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>
                </button>
            </div>

            <div class="md:hidden flex items-center space-x-2">
                <button class="theme-toggle-btn p-2 rounded-full text-gray-700 dark:text-gray-300" aria-label="Toggle theme" type="button">
                     <svg class="theme-toggle-dark-icon hidden h-5 w-5" fill="currentColor" viewBox="0 0 20 20"><path d="M17.293 13.293A8 8 0 016.707 2.707a8.001 8.001 0 1010.586 10.586z"></path></svg>
                     <svg class="theme-toggle-light-icon hidden h-5 w-5" fill="currentColor" viewBox="0 0 20 20"><path d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l.707.707a1 1 0 001.414-1.414l-.707-.707a1 1 0 00-1.414 1.414zm2.121-3.536a1 1 0 010-1.414l.707-.707a1 1 0 111.414 1.414l-.707-.707a1 1 0 01-1.414 0zM10 16a1 1 0 011 1v1a1 1 0 11-2 0v-1a1 1 0 011-1zM4.95 14.536a1 1 0 010-1.414l-.707-.707a1 1 0 00-1.414 1.414l.707.707a1 1 0 001.414 0zm-2.121-3.536a1 1 0 011.414 0l.707.707a1 1 0 11-1.414 1.414l-.707-.707a1 1 0 010-1.414zM10 4a1 1 0 01-1-1V2a1 1 0 112 0v-1a1 1 0 01-1 1z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>
                </button>
                <button type="button" id="mobile-menu-button" class="inline-flex items-center justify-center p-2 rounded-md text-gray-700 dark:text-gray-300" aria-expanded="false" aria-controls="mobile-menu">
                    <span class="sr-only">Open main menu</span>
                    <svg class="h-6 w-6 block" id="menu-open-icon" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25H12" /></svg>
                    <svg class="h-6 w-6 hidden" id="menu-close-icon" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" /></svg>
                </button>
            </div>
        </div>
    </nav>

    <div id="mobile-menu" class="md:hidden hidden bg-white dark:bg-dark-card border-t border-gray-200 dark:border-gray-700">
        <div class="px-2 pt-2 pb-3 space-y-1 sm:px-3">
            <?php foreach ($nav_items as $item):
                $isActive = in_array($current_page, $item['pages']); ?>
                <a href="<?php echo e($item['href']); ?>" class="block px-3 py-2 rounded-md text-base font-medium <?php echo $isActive ? 'text-white bg-brand-orange' : 'text-gray-700 dark:text-gray-200'; ?>">
                    <?php echo e($item['label']); ?>
                </a>
            <?php endforeach; ?>
            <a href="#" id="set-location-btn-mobile" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 dark:text-gray-200">
                Set My Constituency <span class="my-constituency-badge <?php echo $my_constituency_name ? '' : 'hidden'; ?>" aria-live="polite"><?php echo e($my_constituency_name); ?></span>
            </a>
            <a href="admin/login.php" class="block px-3 py-2 rounded-md text-base font-medium text-white bg-brand-blue">Admin Login</a>
        </div>
    </div>
</header>

<div id="aria-announcer" class="sr-only" aria-live="polite" aria-atomic="true"></div>

<div id="location-modal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50 hidden" role="dialog" aria-modal="true" aria-labelledby="location-modal-title" tabindex="-1">
    <div class="relative top-20 mx-auto p-5 border w-full max-w-sm shadow-lg rounded-md bg-white dark:bg-dark-card">
        <div class="mt-3 text-center">
            <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white" id="location-modal-title">Select Your Home Constituency</h3>
            <div class="mt-2 px-7 py-3">
                <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">This helps us show you relevant projects.</p>
                <select id="location-selector" class="w-full rounded-md border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple dark:bg-dark-bg dark:border-gray-600">
                    <option value="">-- Please Select --</option>
                    <?php foreach ($all_constituencies_for_modal as $constituency): ?>
                        <option value="<?php echo e($constituency['id']); ?>" <?php if($my_constituency_id == $constituency['id']) echo 'selected'; ?>><?php echo e($constituency['name']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="items-center px-4 py-3 space-y-2">
                <button id="save-location-btn" class="px-4 py-2 bg-brand-orange text-white text-base font-medium rounded-md w-full shadow-sm hover:bg-opacity-90 disabled:opacity-50 flex items-center justify-center" type="button">
                    <svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-white hidden" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                    <span class="button-text">Save My Choice</span>
                </button>
                <button id="clear-location-btn" class="text-xs text-gray-500 hover:text-brand-orange dark:text-gray-400 dark:hover:text-brand-orange disabled:opacity-50" type="button">Clear My Selection</button>
            </div>
        </div>
    </div>
</div>

<main id="main-content" tabindex="-1">