<?php
// FILE: templates/sidebar_nav.php
// This file contains only the navigation links.
// The header/logo and main logout button are in header.php.

// This is the $current_page_name from header.php
$nav_active = $current_page_name; 

$active_class = 'bg-gray-700 text-white';
$inactive_class = 'text-gray-400 hover:bg-gray-700 hover:text-white';

$role = $_SESSION['user_role'];
?>

<nav class="flex-1 space-y-2 px-4 py-4">
    
    <!-- Universal Links -->
    <a href="index.php?page=dashboard" class="flex items-center px-4 py-3 rounded-lg transition-colors duration-200 <?php echo ($nav_active == 'dashboard') ? $active_class : $inactive_class; ?>">
        <i class="fas fa-home w-6 h-6 mr-3"></i>
        Dashboard
    </a>
    
    <a href="index.php?page=feed" class="flex items-center px-4 py-3 rounded-lg transition-colors duration-200 <?php echo ($nav_active == 'feed') ? $active_class : $inactive_class; ?>">
        <i class="fas fa-rss w-6 h-6 mr-3"></i>
        Community Feed
    </a>

    <!-- Blogger-Only Links -->
    <?php if ($role === 'blogger'): ?>
        <a href="index.php?page=submit_post" class="flex items-center px-4 py-3 rounded-lg transition-colors duration-200 <?php echo ($nav_active == 'submit_post') ? $active_class : $inactive_class; ?>">
            <i class="fas fa-paper-plane w-6 h-6 mr-3"></i>
            Submit Post
        </a>
    <?php endif; ?>

    <!-- Supervisor & Admin Links -->
    <?php if ($role === 'supervisor' || $role === 'admin'): ?>
        <a href="index.php?page=review_posts" class="flex items-center px-4 py-3 rounded-lg transition-colors duration-200 <?php echo ($nav_active == 'review_posts') ? $active_class : $inactive_class; ?>">
            <i class="fas fa-search w-6 h-6 mr-3"></i>
            Review Posts
        </a>
        <a href="index.php?page=review_performance" class="flex items-center px-4 py-3 rounded-lg transition-colors duration-200 <?php echo ($nav_active == 'review_performance') ? $active_class : $inactive_class; ?>">
            <i class="fas fa-chart-line w-6 h-6 mr-3"></i>
            Performance Review
        </a>
        <a href="index.php?page=approve_team" class="flex items-center px-4 py-3 rounded-lg transition-colors duration-200 <?php echo ($nav_active == 'approve_team') ? $active_class : $inactive_class; ?>">
            <i class="fas fa-user-check w-6 h-6 mr-3"></i>
            Approve Team
        </a>
    <?php endif; ?>

    <!-- Admin-Only Links -->
    <?php if ($role === 'admin'): ?>
        <a href="index.php?page=manage_users" class="flex items-center px-4 py-3 rounded-lg transition-colors duration-200 <?php echo ($nav_active == 'manage_users') ? $active_class : $inactive_class; ?>">
            <i class="fas fa-users-cog w-6 h-6 mr-3"></i>
            Manage Users
        </a>
    <?php endif; ?>

</nav>

