<?php
// FILE: pages/review_performance.php
// This is a NEW PAGE for the *Second Step* performance review.

// 1. Security Check
checkSupervisor();

// 2. Get Data: Fetch posts ready for performance review
// This new function gets posts that are 'performance_review' status
// and were approved > 24 hours ago.
$review_posts = getPerformanceReviewPosts($_SESSION['user_id'], $_SESSION['user_role']);

// 3. Get CSRF token
$csrfToken = getCSRFToken();
?>

<!-- 
This page uses the same Alpine.js modal as your original 'review_posts' page
but it submits to a new action: 'perform_review'
-->
<div x-data="{ showModal: false, currentPost: null, csrfToken: '<?php echo $csrfToken; ?>' }">

    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Post Performance Review</h2>

    <?php if (empty($review_posts)): ?>
        <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded-lg">
            <div class="flex">
                <div class="flex-shrink-0">
                    <i class="fas fa-info-circle text-blue-500"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-blue-700">
                        There are no posts ready for performance review (must be > 24 hours old).
                    </p>
                </div>
            </div>
        </div>
    <?php else: ?>
        <!-- Grid layout for review cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach ($review_posts as $post): ?>
                <div class="bg-white rounded-lg shadow-lg overflow-hidden flex flex-col">
                    <div class="p-6 flex-1">
                        <p class="text-sm text-gray-500 mb-2">Blogger: <span class="font-medium text-gray-700"><?php echo htmlspecialchars($post['bloggerEmail']); ?></span></p>
                        <a href="<?php echo htmlspecialchars($post['url']); ?>" target="_blank" rel="noopener noreferrer" class="text-lg font-semibold text-blue-600 hover:text-blue-800 break-all transition-colors">
                            <?php echo htmlspecialchars($post['url']); ?>
                        </a>
                        <p class="text-xs text-gray-500 mt-2">Initial Approval: <?php echo date("M j, Y - g:ia", strtotime($post['approvedAt'])); ?></p>
                    </div>
                    <div class="bg-gray-50 p-4">
                        <button 
                            @click="currentPost = <?php echo htmlspecialchars(json_encode($post)); ?>; showModal = true;"
                            type="button" 
                            class="w-full bg-green-600 text-white font-semibold py-2 px-4 rounded-lg hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2 transition-all">
                            Review Performance
                        </button>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>


    <!-- 
    Performance Review Modal
    -->
    <div 
        x-show="showModal" 
        x-cloak
        @keydown.escape.window="showModal = false"
        class="fixed inset-0 z-50 flex items-center justify-center p-4"
        style="background-color: rgba(0, 0, 0, 0.5);">

        <div 
            @click.away="showModal = false"
            x-show="showModal"
            x-transition
            class="bg-white rounded-lg shadow-xl w-full max-w-lg mx-auto overflow-hidden">

            <div class="flex justify-between items-center p-6 border-b">
                <h3 class="text-2xl font-semibold text-gray-800">Review Performance</h3>
                <button @click="showModal = false" class="text-gray-400 hover:text-gray-600">&times;</button>
            </div>

            <!-- This form submits to the NEW 'perform_review' action -->
            <form action="index.php?action=perform_review" method="POST">
                <input type="hidden" name="csrf_token" :value="csrfToken">
                <input type="hidden" name="post_id" :value="currentPost.id">

                <div class="p-6 space-y-4">
                    <div>
                        <label for="url_review" class="block text-sm font-medium text-gray-700">Post URL</label>
                        <input type="text" id="url_review" :value="currentPost.url" readonly class="mt-1 block w-full px-3 py-2 bg-gray-100 border border-gray-300 rounded-md shadow-sm sm:text-sm">
                    </div>

                    <h4 class="text-lg font-semibold text-gray-700 pt-2 border-t">Enter FINAL Performance Metrics</h4>
                    <p class="text-xs text-gray-500 -mt-2">Earnings will be calculated based on this data. (Reach > 1000 to qualify).</p>
                    
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div>
                            <label for="reach" class="block text-sm font-medium text-gray-700">Total Reach</label>
                            <input type="number" name="reach" id="reach" value="0" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                        </div>
                        <div>
                            <label for="likes" class="block text-sm font-medium text-gray-700">Total Likes</label>
                            <input type="number" name="likes" id="likes" value="0" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                        </div>
                        <div>
                            <label for="comments" class="block text-sm font-medium text-gray-700">Total Comments</label>
                            <input type="number" name="comments" id="comments" value="0" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                        </div>
                        <div>
                            <label for="shares" class="block text-sm font-medium text-gray-700">Total Shares</label>
                            <input type="number" name="shares" id="shares" value="0" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                        </div>
                    </div>
                </div>

                <div class="bg-gray-50 p-6 flex justify-end items-center gap-4">
                    <button @click="showModal = false" type="button" class="inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 sm:text-sm">
                        Cancel
                    </button>
                    <button type="submit" class="inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-green-600 text-base font-medium text-white hover:bg-green-700 focus:ring-green-500 sm:text-sm">
                        Submit Final Review & Pay
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
