<?php
// FILE: pages/manage_users.php
// This page is for Admins only.

// 1. Access Control
checkAdmin();

// 2. Data Fetching
// This function is already in includes/functions.php
$users = getAllUsers();

?>

<div class="space-y-8">
    <h1 class="text-3xl font-bold text-gray-800">Manage Users</h1>

    <!-- Main Content Card -->
    <div class="bg-white rounded-xl shadow-lg overflow-hidden">
        <div class="p-6 border-b border-gray-200">
            <h2 class="text-xl font-semibold text-gray-700">All Registered Users</h2>
            <p class="mt-1 text-sm text-gray-500">
                You can change the role of any user. Be careful when promoting or demoting.
            </p>
        </div>

        <!-- Responsive Table Container -->
        <div class="overflow-x-auto">
            
            <!-- 
                On small screens (mobile), this table will be hidden,
                and the list of cards (see below) will be shown.
            -->
            <table class="min-w-full divide-y divide-gray-200 hidden md:table">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            User
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Contact
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Supervisor
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Status
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Change Role
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php if (empty($users)): ?>
                        <tr>
                            <td colspan="5" class="px-6 py-12 text-center text-gray-500">
                                No users found.
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($users as $user): ?>
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900"><?php echo htmlspecialchars($user['name']); ?></div>
                                    <div class="text-sm text-gray-500"><?php echo htmlspecialchars($user['email']); ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <div><?php echo htmlspecialchars($user['phone_number']); ?></div>
                                    <div><?php echo htmlspecialchars($user['payment_number']); ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <?php echo htmlspecialchars($user['supervisor_email'] ?? 'N/A'); ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php
                                        $status_class = 'bg-gray-100 text-gray-800';
                                        switch ($user['status']) {
                                            case 'approved':
                                                $status_class = 'bg-green-100 text-green-800';
                                                break;
                                            case 'pending':
                                                $status_class = 'bg-yellow-100 text-yellow-800';
                                                break;
                                            case 'pending_admin':
                                                $status_class = 'bg-blue-100 text-blue-800';
                                                break;
                                        }
                                        echo "<span class='px-2 inline-flex text-xs leading-5 font-semibold rounded-full $status_class'>" . htmlspecialchars(ucfirst(str_replace('_', ' ', $user['status']))) . "</span>";
                                    ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <!-- Role Change Form -->
                                    <form action="index.php?page=manage_users" method="POST" class="flex items-center space-x-2">
                                        <input type="hidden" name="action" value="set_role">
                                        <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                                        <input type="hidden" name="csrf_token" value="<?php echo getCSRFToken(); ?>">
                                        
                                        <select name="new_role" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 text-sm">
                                            <option value="blogger" <?php echo ($user['role'] == 'blogger') ? 'selected' : ''; ?>>Blogger</option>
                                            <option value="supervisor" <?php echo ($user['role'] == 'supervisor') ? 'selected' : ''; ?>>Supervisor</option>
                                            <option value="admin" <?php echo ($user['role'] == 'admin') ? 'selected' : ''; ?>>Admin</option>
                                        </select>
                                        
                                        <button type="submit" class="px-3 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium"
                                                <?php echo ($user['id'] == $_SESSION['user_id']) ? 'disabled title="You cannot change your own role." class="px-3 py-2 bg-gray-300 text-gray-500 rounded-md text-sm font-medium cursor-not-allowed"' : ''; ?>>
                                            Save
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>

            <!-- 
                Mobile Card View:
                This list is shown *instead* of the table on small screens.
            -->
            <div class="md:hidden divide-y divide-gray-200">
                <?php if (empty($users)): ?>
                    <div class="p-6 text-center text-gray-500">
                        No users found.
                    </div>
                <?php else: ?>
                    <?php foreach ($users as $user): ?>
                        <div class="p-4 space-y-3">
                            <div>
                                <div class="text-sm font-medium text-gray-900"><?php echo htmlspecialchars($user['name']); ?></div>
                                <div class="text-sm text-gray-500"><?php echo htmlspecialchars($user['email']); ?></div>
                            </div>
                            
                            <div class="text-sm text-gray-500">
                                <?php echo htmlspecialchars($user['phone_number']); ?>
                            </div>

                            <div>
                                <?php
                                    $status_class = 'bg-gray-100 text-gray-800';
                                    switch ($user['status']) {
                                        case 'approved':
                                            $status_class = 'bg-green-100 text-green-800';
                                            break;
                                        case 'pending':
                                            $status_class = 'bg-yellow-100 text-yellow-800';
                                            break;
                                        case 'pending_admin':
                                            $status_class = 'bg-blue-100 text-blue-800';
                                            break;
                                    }
                                    echo "<span class='px-2 inline-flex text-xs leading-5 font-semibold rounded-full $status_class'>" . htmlspecialchars(ucfirst(str_replace('_', ' ', $user['status']))) . "</span>";
                                ?>
                            </div>

                            <form action="index.php?page=manage_users" method="POST" class="space-y-2">
                                <input type="hidden" name="action" value="set_role">
                                <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">
                                <input type="hidden" name="csrf_token" value="<?php echo getCSRFToken(); ?>">
                                
                                <select name="new_role" class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 text-sm">
                                    <option value="blogger" <?php echo ($user['role'] == 'blogger') ? 'selected' : ''; ?>>Blogger</option>
                                    <option value="supervisor" <?php echo ($user['role'] == 'supervisor') ? 'selected' : ''; ?>>Supervisor</option>
                                    <option value="admin" <?php echo ($user['role'] == 'admin') ? 'selected' : ''; ?>>Admin</option>
                                </select>
                                
                                <button type="submit" class="w-full px-3 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium"
                                        <?php echo ($user['id'] == $_SESSION['user_id']) ? 'disabled title="You cannot change your own role." class="w-full px-3 py-2 bg-gray-300 text-gray-500 rounded-md text-sm font-medium cursor-not-allowed"' : ''; ?>>
                                    Save Role
                                </button>
                            </form>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

