<?php
// FILE: pages/approve_team.php
// This page allows Supervisors and Admins to approve or reject new bloggers.

// 1. Fetch Data
// This function is role-aware. 
// If you're a supervisor, it gets *your* pending bloggers.
// If you're an admin, it gets *all* pending bloggers AND pending supervisors.
$pending_users = getPendingTeam($user_id, $user_role);
?>

<div class="bg-white rounded-xl shadow-lg overflow-hidden border border-gray-100">
    <div class="p-6 border-b border-gray-200">
        <h2 class="text-2xl font-bold text-gray-800">Approve New Users</h2>
        <p class="mt-1 text-sm text-gray-600">
            Review new users pending approval.
        </p>
    </div>

    <!-- Responsive Table Container -->
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Role</th>
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Registered</th>
                    
                    <?php if ($user_role === 'admin'): // Admins see the supervisor ?>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Assigned Supervisor</th>
                    <?php endif; ?>
                    
                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">

                <?php if (empty($pending_users)): ?>
                    <tr>
                        <td colspan="<?php echo ($user_role === 'admin') ? '5' : '4'; ?>" class="px-6 py-8 text-center text-gray-500">
                            There are no pending users to approve.
                        </td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($pending_users as $user): ?>
                        <tr>
                            <!-- User Column (Name & Email) -->
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900"><?php echo htmlspecialchars($user['name']); ?></div>
                                <div class="text-sm text-gray-500"><?php echo htmlspecialchars($user['email']); ?></div>
                            </td>
                            
                            <!-- Role Column -->
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full 
                                    <?php echo ($user['role'] === 'blogger') ? 'bg-blue-100 text-blue-800' : 'bg-purple-100 text-purple-800'; ?>">
                                    <?php echo htmlspecialchars(ucfirst($user['role'])); ?>
                                </span>
                            </td>

                            <!-- Registered Column -->
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-700"><?php echo date('M d, Y', strtotime($user['createdAt'])); ?></div>
                            </td>

                            <!-- Assigned Supervisor Column (Admin Only) -->
                            <?php if ($user_role === 'admin'): ?>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-700"><?php echo htmlspecialchars($user['supervisorEmail'] ?? 'N/A'); ?></div>
                                </td>
                            <?php endif; ?>

                            <!-- Actions Column -->
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <div class="flex items-center space-x-2">
                                    <!-- Approve Form -->
                                    <form action="index.php?page=approve_team" method="POST" class="inline">
                                        <input type="hidden" name="csrf_token" value="<?php echo getCSRFToken(); ?>">
                                        <input type="hidden" name="action" value="approve_user">
                                        <input type="hidden" name="bloggerId" value="<?php echo $user['id']; ?>">
                                        <button type="submit" class="text-white bg-green-600 hover:bg-green-700 font-medium rounded-lg text-xs px-3 py-2 text-center transition-colors">
                                            Approve
                                        </button>
                                    </form>
                                    
                                    <!-- Reject Form -->
                                    <form action="index.php?page=approve_team" method="POST" class="inline">
                                        <input type="hidden" name="csrf_token" value="<?php echo getCSRFToken(); ?>">
                                        <input type="hidden" name="action" value="reject_user">
                                        <input type="hidden" name="bloggerId" value="<?php echo $user['id']; ?>">
                                        <button type="submit" class="text-white bg-red-600 hover:bg-red-700 font-medium rounded-lg text-xs px-3 py-2 text-center transition-colors">
                                            Reject
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>

            </tbody>
        </table>
    </div>
</div>

