<?php
// FILE: logout.php
// This script securely logs out the user, kills the session, and removes any 'remember me' cookies.

// We must start the session to be able to access and destroy it.
// We'll use the same secure start function from functions.php.
require_once 'includes/functions.php';
secure_session_start();

// 1. Unset all of the session variables.
$_SESSION = array();

// 2. Destroy any "Remember Me" cookie.
// This assumes your cookie is named 'remember_token'.
// You must use this same name in your handleLogin() function when the user checks "Remember me".
if (isset($_COOKIE['remember_token'])) {
    // Unset it from the script's memory
    unset($_COOKIE['remember_token']);
    // Set the cookie to a time in the past (1 hour ago) to force the browser to delete it.
    // Make sure the path matches the one you set during login (we'll assume '/' for site-wide).
    setcookie('remember_token', '', time() - 3600, '/');
}

// 3. Finally, destroy the session on the server.
session_destroy();

// 4. Redirect to the login page with no session data.
header("Location: login.php");
exit;
?>

