<?php
// FILE: login.php
// This is the public login page for the blogger portal.

// We need the database connection and both function files
require_once 'includes/db.php';
require_once 'includes/functions.php'; // Helpers & Data Fetchers
require_once 'includes/functions2.php'; // Action Handlers (This was the fix)

// Start the secure session
secure_session_start();

// If user is already logged in, redirect them to the dashboard
if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

// --- Login Form Handling ---
$error_message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // The handleLogin function will either redirect on success
    // or return an error message string on failure.
    $error_message = handleLogin();
}

// Get a CSRF token for the form
$csrfToken = getCSRFToken();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Genowa Blogger Portal</title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <!-- Google Font: Inter -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- Favicon -->
    <link rel="icon" href="data:image/svg+xml,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 100 100%22><text y=%22.9em%22 font-size=%2290%22>🌿</text></svg>">
    
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        /* Custom brand color */
        .focus\:ring-brand-green:focus {
            --tw-ring-color: #10B981; /* Tailwind 'green-500' */
        }
        .focus\:border-brand-green:focus {
            --tw-border-opacity: 1;
            border-color: #10B981;
        }
    </style>
</head>
<body class="bg-gray-100">

<div class="flex items-center justify-center min-h-screen px-4">
    <div class="w-full max-w-md p-8 space-y-6 bg-white rounded-2xl shadow-xl">
        
        <!-- Logo and Title -->
        <div class="text-center">
            <i class="fas fa-leaf text-5xl text-green-600"></i>
            <h2 class="mt-4 text-3xl font-extrabold text-gray-900">
                Genowa Portal Login
            </h2>
            <p class="mt-2 text-sm text-gray-600">
                Sign in to manage your posts and earnings.
            </p>
        </div>

        <!-- Error Message Display -->
        <?php if (!empty($error_message)): ?>
            <div class="p-4 bg-red-100 border-l-4 border-red-500 text-red-700 rounded-lg" role="alert">
                <p class="font-bold">Login Failed</p>
                <p><?php echo htmlspecialchars($error_message); ?></p>
            </div>
        <?php endif; ?>

        <!-- Login Form -->
        <form class="space-y-6" action="login.php" method="POST">
            <!-- CSRF Token -->
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrfToken); ?>">
            
            <div class="space-y-4">
                <!-- Email Address -->
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fas fa-envelope text-gray-400"></i>
                    </div>
                    <input id="email" name="email" type="email" autocomplete="email" required 
                           class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg placeholder-gray-500 focus:outline-none focus:ring-brand-green focus:border-brand-green sm:text-sm" 
                           placeholder="Email address">
                </div>
                
                <!-- Password -->
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fas fa-lock text-gray-400"></i>
                    </div>
                    <input id="password" name="password" type="password" autocomplete="current-password" required 
                           class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg placeholder-gray-500 focus:outline-none focus:ring-brand-green focus:border-brand-green sm:text-sm" 
                           placeholder="Password">
                </div>
            </div>

            <div class="flex items-center justify-between">
                <!-- Remember Me (Non-functional in this version, but good UI) -->
                <div class="flex items-center">
                    <input id="remember-me" name="remember-me" type="checkbox" 
                           class="h-4 w-4 text-green-600 border-gray-300 rounded focus:ring-brand-green">
                    <label for="remember-me" class="ml-2 block text-sm text-gray-900"> Remember me </label>
                </div>

                <!-- Forgot Password (Non-functional) -->
                <div class="text-sm">
                    <a href="#" class="font-medium text-green-600 hover:text-green-500"> Forgot your password? </a>
                </div>
            </div>

            <!-- Sign In Button -->
            <div>
                <button type="submit" 
                        class="group relative w-full flex justify-center py-3 px-4 border border-transparent text-sm font-semibold rounded-lg text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition-colors">
                    <span class="absolute left-0 inset-y-0 flex items-center pl-3">
                        <i class="fas fa-lock h-5 w-5 text-green-300 group-hover:text-green-100"></i>
                    </span>
                    Sign in
                </button>
            </div>
        </form>

        <!-- Link to Register -->
        <p class="text-center text-sm text-gray-600">
            Don't have an account?
            <a href="register.php" class="font-medium text-green-600 hover:text-green-500">
                Register here
            </a>
        </p>

    </div>
</div>

</body>
</html>

