<?php
require_once '../functions.php';
require_once '../db_connect.php';
require_login();
if (!is_admin() && !is_super_admin()) {
    die("Unauthorized.");
}

$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT file_path, title FROM knowledge_base WHERE id=?");
$stmt->execute([$id]);
$doc = $stmt->fetch();

if (!$doc) {
    die("File not found.");
}

$file = realpath($doc['file_path']);
$uploadsRoot = realpath("../uploads/knowledge_base/");

// Security: ensure file is in allowed dir
if (strpos($file, $uploadsRoot) !== 0 || !file_exists($file)) {
    die("Unauthorized file access.");
}

// Set download headers
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="'.basename($file).'"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($file));
readfile($file);
exit;
?>
