<?php
// FILE: admin/ajax_wards.php
// PURPOSE: Return all wards for a given constituency as JSON (for dependent dropdown)

// Secure: Only allow AJAX (GET) requests from logged in users
require_once 'db.php';
require_once 'functions.php';
require_login();

header('Content-Type: application/json');

$constituency_id = isset($_GET['constituency_id']) ? (int)$_GET['constituency_id'] : 0;

if ($constituency_id > 0) {
    $stmt = $pdo->prepare("SELECT id, name FROM wards WHERE constituency_id = ? ORDER BY name ASC");
    $stmt->execute([$constituency_id]);
    $wards = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($wards);
} else {
    echo json_encode([]);
}
