<?php
// FILE: admin/partials/project_photos_form.php
?>
<div class="bg-white p-8 rounded-xl shadow-md">
    <form action="manage_project.php?id=<?php echo e($project_id); ?>&tab=photos" method="post" enctype="multipart/form-data" class="mb-12 border-b border-gray-200 pb-8">
        <input type="hidden" name="csrf_token" value="<?php echo e($csrf_token); ?>">
        <input type="hidden" name="action" value="upload_photo">
        <h3 class="text-xl font-semibold text-brand-orange">Upload New Photo</h3>
        
        <!-- NEW: Image Preview Area -->
        <div class="mt-4 hidden" id="image-preview-wrapper">
            <label class="block text-sm font-medium text-gray-700">Image Preview</label>
            <img id="image-preview" src="#" alt="Image Preview" class="mt-1 rounded-lg max-h-60 w-auto shadow-sm"/>
        </div>

        <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="md:col-span-2">
                 <label for="project_photo" class="block text-sm font-medium text-gray-700">Photo File</label>
                 <input type="file" name="project_photo" id="project_photo" required class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-brand-purple hover:file:bg-purple-100">
            </div>
            <div>
                <label for="caption" class="block text-sm font-medium text-gray-700">Optional Caption</label>
                <input type="text" name="caption" id="caption" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm">
            </div>
            <div>
                <label for="photo_type" class="block text-sm font-medium text-gray-700">Photo Type</label>
                <select name="photo_type" id="photo_type" required class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm">
                    <option value="Progress">Progress</option>
                    <option value="Before">Before</option>
                    <option value="After">After</option>
                </select>
            </div>
        </div>
        <div class="mt-6 flex justify-end">
             <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-brand-orange hover:bg-orange-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-brand-purple">
                Upload Photo
            </button>
        </div>
    </form>

    <h3 class="text-xl font-semibold text-brand-orange mt-8 mb-6">Existing Photos</h3>
    <?php if (empty($project_photos)): ?>
        <p class="text-gray-500 text-center py-8">No photos have been uploaded for this project yet.</p>
    <?php else: ?>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            <?php foreach ($project_photos as $photo): ?>
                <div class="group relative rounded-lg overflow-hidden shadow-lg border">
                    <img src="uploads/<?php echo e($photo['image_url']); ?>" alt="<?php echo e($photo['caption']); ?>" class="h-56 w-full object-cover">
                    <?php if ($photo['is_featured']): ?>
                        <div class="absolute top-2 left-2 bg-brand-purple text-white text-xs font-bold px-2 py-1 rounded-full">Featured</div>
                    <?php endif; ?>
                    <div class="absolute bottom-0 left-0 right-0 p-3 bg-gradient-to-t from-black/70 to-transparent text-white">
                        <p class="text-sm font-bold"><?php echo e($photo['photo_type']); ?></p>
                        <p class="text-xs truncate"><?php echo e($photo['caption']); ?></p>
                    </div>
                    <div class="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-50 transition-opacity flex items-center justify-center space-x-2">
                        <form action="manage_project.php?id=<?php echo e($project_id); ?>&tab=photos" method="POST" class="opacity-0 group-hover:opacity-100 transition-opacity">
                            <input type="hidden" name="csrf_token" value="<?php echo e($csrf_token); ?>">
                            <input type="hidden" name="photo_id" value="<?php echo e($photo['id']); ?>">
                            <input type="hidden" name="action" value="set_featured_photo">
                            <button type="submit" title="Set as Featured" class="bg-blue-500 text-white rounded-full p-2 hover:bg-blue-600 disabled:bg-gray-400" <?php if ($photo['is_featured']) echo 'disabled'; ?>>
                                <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                            </button>
                        </form>
                         <form action="manage_project.php?id=<?php echo e($project_id); ?>&tab=photos" method="POST" class="opacity-0 group-hover:opacity-100 transition-opacity" onsubmit="return confirm('Are you sure you want to delete this photo?');">
                            <input type="hidden" name="csrf_token" value="<?php echo e($csrf_token); ?>">
                            <input type="hidden" name="photo_id" value="<?php echo e($photo['id']); ?>">
                            <input type="hidden" name="action" value="delete_photo">
                            <button type="submit" title="Delete Photo" class="bg-red-600 text-white rounded-full p-2 hover:bg-red-700">
                                <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm4 0a1 1 0 012 0v6a1 1 0 11-2 0V8z" clip-rule="evenodd" /></svg>
                            </button>
                        </form>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const photoInput = document.getElementById('project_photo');
    const imagePreview = document.getElementById('image-preview');
    const imagePreviewWrapper = document.getElementById('image-preview-wrapper');

    photoInput.addEventListener('change', function() {
        if (this.files && this.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                imagePreview.setAttribute('src', e.target.result);
                imagePreviewWrapper.classList.remove('hidden');
            }
            reader.readAsDataURL(this.files[0]);
        }
    });
});
</script>
