<?php
// FILE: admin/partials/project_details_form.php
?>
<div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
    <div class="lg:col-span-2">
        <form action="manage_project.php?id=<?php echo e($project_id); ?>" method="POST">
            <input type="hidden" name="csrf_token" value="<?php echo e($csrf_token); ?>">
            <input type="hidden" name="id" value="<?php echo e($project_id); ?>">
            <input type="hidden" name="action" value="save_details">

            <div class="bg-white p-8 rounded-xl shadow-md space-y-8">
                <!-- Core Details -->
                <fieldset>
                    <legend class="text-xl font-semibold text-brand-orange">Core Details</legend>
                    <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="md:col-span-2">
                            <label for="name" class="block text-sm font-medium text-gray-700">Project Name</label>
                            <input type="text" name="name" id="name" value="<?php echo e($project['name'] ?? ''); ?>" required class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-lg" <?php if (!$can_edit) echo 'readonly'; ?>>
                        </div>
                        <div class="md:col-span-2">
                            <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                            <textarea name="description" id="description" rows="4" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>><?php echo e($project['description'] ?? ''); ?></textarea>
                        </div>
                        <div>
                            <label for="ward_id" class="block text-sm font-medium text-gray-700">Ward</label>
                            <select name="ward_id" id="ward_id" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!is_super_admin() || !$can_edit) echo 'disabled'; ?>>
                                <?php foreach ($wards as $ward): ?>
                                    <option value="<?php echo e($ward['id']); ?>" <?php echo (($project['ward_id'] ?? $_SESSION['ward_id']) == $ward['id']) ? 'selected' : ''; ?>><?php echo e($ward['name']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div>
                            <label for="manifesto_pillar_id" class="block text-sm font-medium text-gray-700">Manifesto Pillar</label>
                            <select name="manifesto_pillar_id" id="manifesto_pillar_id" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>>
                                 <?php foreach ($manifesto_pillars as $pillar): ?>
                                    <option value="<?php echo e($pillar['id']); ?>" <?php echo (($project['manifesto_pillar_id'] ?? '') == $pillar['id']) ? 'selected' : ''; ?>><?php echo e($pillar['title']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </fieldset>

                <!-- Status & Financials -->
                <fieldset>
                    <legend class="text-xl font-semibold text-brand-orange">Status, Progress & Financials</legend>
                    <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="status" class="block text-sm font-medium text-gray-700">Project Status</label>
                            <select name="status" id="status" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>>
                                <?php $statuses = ['Planned', 'Ongoing', 'Completed', 'Stalled']; ?>
                                <?php foreach ($statuses as $status): ?>
                                    <option value="<?php echo $status; ?>" <?php echo (($project['status'] ?? 'Planned') == $status) ? 'selected' : ''; ?>><?php echo $status; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div>
                            <label for="manual_progress" class="block text-sm font-medium text-gray-700">Manual Progress (%)</label>
                            <input type="number" name="manual_progress" id="manual_progress" min="0" max="100" value="<?php echo e($project['manual_progress'] ?? 0); ?>" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>>
                        </div>
                        <div>
                            <label for="budget_allocated" class="block text-sm font-medium text-gray-700">Budget Allocated (KES)</label>
                            <input type="number" step="0.01" name="budget_allocated" id="budget_allocated" value="<?php echo e($project['budget_allocated'] ?? '0.00'); ?>" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>>
                        </div>
                        <div>
                            <label for="budget_spent" class="block text-sm font-medium text-gray-700">Budget Spent (KES)</label>
                            <input type="number" step="0.01" name="budget_spent" id="budget_spent" value="<?php echo e($project['budget_spent'] ?? ''); ?>" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>>
                        </div>
                    </div>
                </fieldset>
                
                <!-- Dates & Contractor -->
                <fieldset>
                    <legend class="text-xl font-semibold text-brand-orange">Dates & Contractor</legend>
                    <div class="mt-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <div>
                             <label for="start_date" class="block text-sm font-medium text-gray-700">Start Date</label>
                             <input type="date" name="start_date" id="start_date" value="<?php echo e($project['start_date'] ?? ''); ?>" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>>
                        </div>
                        <div>
                            <label for="expected_completion_date" class="block text-sm font-medium text-gray-700">Expected Completion</label>
                             <input type="date" name="expected_completion_date" id="expected_completion_date" value="<?php echo e($project['expected_completion_date'] ?? ''); ?>" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>>
                        </div>
                        <div>
                            <label for="actual_completion_date" class="block text-sm font-medium text-gray-700">Actual Completion</label>
                             <input type="date" name="actual_completion_date" id="actual_completion_date" value="<?php echo e($project['actual_completion_date'] ?? ''); ?>" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>>
                        </div>
                        <div class="md:col-span-2">
                             <label for="contractor_name" class="block text-sm font-medium text-gray-700">Contractor Name</label>
                             <input type="text" name="contractor_name" id="contractor_name" value="<?php echo e($project['contractor_name'] ?? ''); ?>" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>>
                        </div>
                    </div>
                </fieldset>

                <!-- Location & Beneficiaries -->
                <fieldset>
                    <legend class="text-xl font-semibold text-brand-orange">Location & Beneficiaries</legend>
                    <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="latitude" class="block text-sm font-medium text-gray-700">Latitude</label>
                            <input type="text" name="latitude" id="latitude" value="<?php echo e($project['latitude'] ?? ''); ?>" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>>
                        </div>
                        <div>
                            <label for="longitude" class="block text-sm font-medium text-gray-700">Longitude</label>
                            <input type="text" name="longitude" id="longitude" value="<?php echo e($project['longitude'] ?? ''); ?>" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>>
                        </div>
                        <div class="md:col-span-2">
                            <label for="beneficiaries_summary" class="block text-sm font-medium text-gray-700">Beneficiaries Summary</label>
                            <textarea name="beneficiaries_summary" id="beneficiaries_summary" rows="3" class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm" <?php if (!$can_edit) echo 'readonly'; ?>><?php echo e($project['beneficiaries_summary'] ?? ''); ?></textarea>
                        </div>
                    </div>
                </fieldset>
                
                <?php if ($can_edit): ?>
                <div class="pt-5 border-t border-gray-200">
                    <div class="flex justify-end">
                        <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-brand-orange hover:bg-orange-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-brand-purple">
                            <?php echo $is_edit_mode ? 'Save Changes' : 'Create Project & Add Photos'; ?>
                        </button>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <!-- Sidebar for Approval & Comments -->
    <div class="space-y-8">
        <?php if ($is_edit_mode && $user_can_approve && $project['is_approved'] != 1): ?>
        <div class="bg-white p-8 rounded-xl shadow-md">
            <h3 class="text-xl font-semibold text-brand-blue">Project Review & Approval</h3>
            <p class="mt-1 text-sm text-gray-600">Review the details and comments, then approve or request changes.</p>
            <form action="manage_project.php?id=<?php echo e($project_id); ?>" method="POST" class="mt-6 space-y-4">
                <input type="hidden" name="csrf_token" value="<?php echo e($csrf_token); ?>">
                <input type="hidden" name="action" value="approve_decline">
                <div>
                    <label for="approval_comment" class="block text-sm font-medium text-gray-700">Review Comment (Required)</label>
                    <textarea name="approval_comment" id="approval_comment" rows="4" required class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:border-brand-purple focus:ring-brand-purple sm:text-sm"></textarea>
                    <p class="mt-2 text-xs text-gray-500">This comment will be sent to the project creator.</p>
                </div>
                <div class="flex justify-end space-x-3">
                    <button type="submit" name="decision" value="decline" class="px-4 py-2 text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700">Decline & Request Changes</button>
                    <button type="submit" name="decision" value="approve" class="px-4 py-2 text-sm font-medium rounded-md text-white bg-green-600 hover:bg-green-700">Approve Project</button>
                </div>
            </form>
        </div>
        <?php endif; ?>
        
        <?php if (!empty($approval_comments)): ?>
        <div class="bg-white p-8 rounded-xl shadow-md">
            <h3 class="text-xl font-semibold text-brand-blue">Review History</h3>
            <div class="mt-4 space-y-4 max-h-96 overflow-y-auto">
                <?php foreach($approval_comments as $comment): ?>
                <div class="p-4 rounded-lg <?php echo $comment['decision'] == 'Approved' ? 'bg-green-50' : 'bg-red-50'; ?>">
                    <div class="flex justify-between items-center">
                        <p class="text-sm font-semibold text-gray-800"><?php echo e($comment['author_name']); ?></p>
                        <p class="text-xs text-gray-500"><?php echo date('M j, Y H:i', strtotime($comment['created_at'])); ?></p>
                    </div>
                    <p class="mt-2 text-sm text-gray-700"><?php echo nl2br(e($comment['comment'])); ?></p>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
