<?php
// FILE: admin/db.php
// PURPOSE: Establishes a PDO database connection using settings from config.ini.
// This file will be included in other files that need database access.

// Read configuration from .ini file
// The '@' suppresses errors if the file doesn't exist, which we handle manually.
$config = @parse_ini_file('config.ini', true);
if (!$config) {
    die("Error: Unable to read the configuration file (config.ini). Please ensure it exists and is readable.");
}

$db_config = $config['database'];

$host = $db_config['host'];
$dbname = $db_config['dbname'];
$user = $db_config['user'];
$pass = $db_config['password'];
$charset = $db_config['charset'];

// Data Source Name (DSN)
$dsn = "mysql:host=$host;dbname=$dbname;charset=$charset";

// PDO Options
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION, // Throw exceptions on errors
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,       // Fetch associative arrays
    PDO::ATTR_EMULATE_PREPARES   => false,                  // Use native prepared statements
];

try {
    // Create a new PDO instance
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    // If connection fails, stop the script and show an error.
    // In a production environment, you would log this error and show a generic message.
    http_response_code(500);
    die("Database Connection Error: Could not connect to the database. Please check your configuration.");
    // For debugging, you might use:
    // throw new \PDOException($e->getMessage(), (int)$e->getCode());
}
?>
