<?php
// FILE: admin/config.php
// PURPOSE: Establishes global configuration settings from config.ini.

// The '@' suppresses errors if the file doesn't exist, which we handle manually.
$config = @parse_ini_file(__DIR__ . '/config.ini', true);
if (!$config) {
    // Use __DIR__ to ensure the path is always correct, regardless of where the script is included from.
    error_log("FATAL ERROR: Unable to read the configuration file (config.ini). Please ensure it exists in the 'admin' directory and is readable.");
    // In a production environment, you would show a user-friendly error page.
    http_response_code(500);
    die("A critical configuration error occurred. Please contact the system administrator.");
}
?>
