<?php
// FILE: admin/actions/project_save_details.php

$current_project_id = $_POST['id'] ?? null;
$is_edit_mode_on_post = !empty($current_project_id);

// Gather all data from the form submission
$project_data = [
    'name' => trim($_POST['name']),
    'description' => trim($_POST['description']),
    'status' => trim($_POST['status']),
    'budget_allocated' => trim($_POST['budget_allocated']) ?: 0,
    'budget_spent' => empty(trim($_POST['budget_spent'])) ? null : trim($_POST['budget_spent']),
    'start_date' => empty(trim($_POST['start_date'])) ? null : trim($_POST['start_date']),
    'expected_completion_date' => empty(trim($_POST['expected_completion_date'])) ? null : trim($_POST['expected_completion_date']),
    'actual_completion_date' => empty(trim($_POST['actual_completion_date'])) ? null : trim($_POST['actual_completion_date']),
    'beneficiaries_summary' => trim($_POST['beneficiaries_summary']),
    'contractor_name' => trim($_POST['contractor_name']),
    'manifesto_pillar_id' => trim($_POST['manifesto_pillar_id']),
    'ward_id' => is_super_admin() ? trim($_POST['ward_id']) : ($project['ward_id'] ?? $_SESSION['ward_id']),
    'latitude' => trim($_POST['latitude']) ?: null,
    'longitude' => trim($_POST['longitude']) ?: null,
    'manual_progress' => isset($_POST['manual_progress']) && $_POST['manual_progress'] !== '' ? trim($_POST['manual_progress']) : null,
];

// Basic server-side validation
if (empty($project_data['name'])) $errors['name'] = "Project name is required.";
if (empty($project_data['ward_id'])) $errors['ward_id'] = "Ward is required.";
if (empty($project_data['manifesto_pillar_id'])) $errors['manifesto_pillar_id'] = "Manifesto Pillar is required.";

// Proceed only if there are no validation errors
if (empty($errors)) {
    if ($is_edit_mode_on_post) {
        // SQL for updating an existing project
        $sql = "UPDATE projects SET name = :name, description = :description, status = :status, budget_allocated = :budget_allocated, budget_spent = :budget_spent, start_date = :start_date, expected_completion_date = :expected_completion_date, actual_completion_date = :actual_completion_date, beneficiaries_summary = :beneficiaries_summary, contractor_name = :contractor_name, ward_id = :ward_id, latitude = :latitude, longitude = :longitude, manifesto_pillar_id = :manifesto_pillar_id, manual_progress = :manual_progress, last_updated_by = :last_updated_by, is_approved = 0 WHERE id = :id";
        $project_data['last_updated_by'] = $_SESSION['id'];
        $project_data['id'] = $current_project_id;
    } else {
        // SQL for inserting a new project
        $sql = "INSERT INTO projects (name, description, status, budget_allocated, budget_spent, start_date, expected_completion_date, actual_completion_date, beneficiaries_summary, contractor_name, ward_id, latitude, longitude, manifesto_pillar_id, manual_progress, created_by, last_updated_by) VALUES (:name, :description, :status, :budget_allocated, :budget_spent, :start_date, :expected_completion_date, :actual_completion_date, :beneficiaries_summary, :contractor_name, :ward_id, :latitude, :longitude, :manifesto_pillar_id, :manual_progress, :created_by, :last_updated_by)";
        $project_data['created_by'] = $_SESSION['id'];
        $project_data['last_updated_by'] = $_SESSION['id'];
    }
    
    $stmt = $pdo->prepare($sql);
    
    // **CRITICAL: Explicit success/failure check and logging**
    $execution_success = $stmt->execute($project_data);

    if ($execution_success) {
        // --- Success Path ---
        $new_id = $is_edit_mode_on_post ? $current_project_id : $pdo->lastInsertId();
        log_action($pdo, $is_edit_mode_on_post ? 'Updated Project' : 'Created Project', 'Project', $new_id);

        // Redirect to the next step (photo management)
        header("location: manage_project.php?id=" . $new_id . "&tab=photos&success=saved");
        exit;
    } else {
        // --- Failure Path ---
        $error_info = $stmt->errorInfo();
        // Construct a detailed error message for the server log
        $error_message_for_log = "Database save failed for project details. SQLSTATE[{$error_info[0]}] [{$error_info[1]}] {$error_info[2]}";
        error_log($error_message_for_log); // This writes the detailed error to your server's log file.

        // Set a user-friendly error to be displayed on the form
        $errors['db_save'] = "There was a problem saving the project to the database. Please check the server error logs for details or contact support.";
    }
}
