<?php
// FILE: admin/actions/project_delete_photo.php

$photo_id = $_POST['photo_id'] ?? null;
if ($photo_id) {
    $stmt = $pdo->prepare("SELECT * FROM project_photos WHERE id = :id AND project_id = :project_id");
    $stmt->execute(['id' => $photo_id, 'project_id' => $project_id]);
    $photo = $stmt->fetch();

    if ($photo) {
        // Delete the physical file
        if (file_exists(PROJECT_PHOTOS_UPLOAD_DIR . $photo['file_name'])) {
            unlink(PROJECT_PHOTOS_UPLOAD_DIR . $photo['file_name']);
        }
        // Delete the database record
        $delete_stmt = $pdo->prepare("DELETE FROM project_photos WHERE id = :id");
        $delete_stmt->execute(['id' => $photo_id]);
        $success_message = "Photo deleted successfully.";
    } else {
        $errors['photo'] = "Photo not found or you do not have permission to delete it.";
    }
}
