<?php
// FILE: admin/actions/project_approve_decline.php

$decision = $_POST['decision'] ?? '';
$comment = trim($_POST['approval_comment'] ?? '');

if (empty($comment)) {
    $errors['comment'] = "An approval or rejection comment is required.";
}

if (empty($errors)) {
    $new_status = ($decision == 'approve') ? 1 : 2; // 1 = Approved, 2 = Changes Requested
    $decision_text = ($decision == 'approve') ? 'Approved' : 'Changes Requested';

    // Update project status
    $sql = "UPDATE projects SET is_approved = :status, approved_by = :approved_by, approved_at = NOW() WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['status' => $new_status, 'approved_by' => $_SESSION['id'], 'id' => $project_id]);

    // Log the comment
    $comment_sql = "INSERT INTO project_approval_comments (project_id, user_id, comment, decision) VALUES (:project_id, :user_id, :comment, :decision)";
    $comment_stmt = $pdo->prepare($comment_sql);
    $comment_stmt->execute([
        'project_id' => $project_id,
        'user_id' => $_SESSION['id'],
        'comment' => $comment,
        'decision' => $decision_text
    ]);
    
    log_action($pdo, $decision_text . ' Project', 'Project', $project_id);
    
    // Send email notification to the project creator
    // (Assuming send_email function and email template exist)

    $success_message = "Project has been successfully " . strtolower($decision_text) . ".";
    // Refresh the project data to show the new status immediately
    $stmt = $pdo->prepare("SELECT p.*, u.name as creator_name FROM projects p JOIN users u ON p.created_by = u.id WHERE p.id = :id");
    $stmt->execute(['id' => $project_id]);
    $project = $stmt->fetch(PDO::FETCH_ASSOC);
}
