<?php
// FILE: admin/partials/project_details_form.php
// PURPOSE: The form for project details, now with all fields and aware of user roles.

// This variable is passed from manage_project.php
$is_disabled = !$can_edit ? 'disabled' : ''; 
?>
<div class="bg-white rounded-lg shadow-lg p-8">
    <form action="<?php echo htmlspecialchars($_SERVER['REQUEST_URI']); ?>" method="post" class="space-y-8">
        
        <input type="hidden" name="id" value="<?php echo e($project['id'] ?? null); ?>">
        
        <fieldset class="p-6 border border-gray-200 rounded-lg">
            <legend class="px-2 text-lg font-semibold text-brand-orange">Core Details</legend>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-6 mt-4">
                <div class="md:col-span-2">
                    <label for="name" class="block text-sm font-bold text-brand-blue mb-1">Project Name</label>
                    <input type="text" name="name" id="name" value="<?php echo e($project['name'] ?? ''); ?>" class="block w-full rounded-lg border-gray-300 shadow-sm px-4 py-3 text-base disabled:bg-gray-100" <?php echo $is_disabled; ?>>
                </div>
                <div class="md:col-span-2">
                    <label for="description" class="block text-sm font-bold text-brand-blue mb-1">Project Description</label>
                    <textarea name="description" id="description" rows="4" class="block w-full rounded-lg border-gray-300 shadow-sm px-4 py-3 text-base disabled:bg-gray-100" <?php echo $is_disabled; ?>><?php echo e($project['description'] ?? ''); ?></textarea>
                </div>
                <div>
                    <label for="ward_id" class="block text-sm font-bold text-brand-blue mb-1">Ward</label>
                    <?php if (is_super_admin()): ?>
                        <select name="ward_id" id="ward_id" class="block w-full rounded-lg border-gray-300 shadow-sm px-4 py-3 text-base" <?php echo $is_disabled; ?>>
                            <option value="">Select a Ward</option>
                            <?php foreach ($wards as $ward): ?>
                                <option value="<?php echo e($ward['id']); ?>" <?php echo (($project['ward_id'] ?? '') == $ward['id']) ? 'selected' : ''; ?>>
                                    <?php echo e($ward['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    <?php else: ?>
                        <?php 
                            $ward_name_display = 'N/A';
                            foreach($wards as $w) { if ($w['id'] == ($project['ward_id'] ?? '')) { $ward_name_display = $w['name']; break; } }
                        ?>
                        <p class="block w-full rounded-lg bg-gray-100 px-4 py-3 text-base border border-gray-300"><?php echo e($ward_name_display); ?></p>
                    <?php endif; ?>
                </div>
                 <div>
                    <label for="manifesto_pillar_id" class="block text-sm font-bold text-brand-blue mb-1">Manifesto Pillar</label>
                    <select name="manifesto_pillar_id" id="manifesto_pillar_id" class="block w-full rounded-lg border-gray-300 shadow-sm px-4 py-3 text-base" <?php echo $is_disabled; ?>>
                        <option value="">Select a Pillar</option>
                        <?php foreach ($manifesto_pillars as $pillar): ?>
                            <option value="<?php echo e($pillar['id']); ?>" <?php echo (($project['manifesto_pillar_id'] ?? '') == $pillar['id']) ? 'selected' : ''; ?>>
                                <?php echo e($pillar['title']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label for="latitude" class="block text-sm font-bold text-brand-blue mb-1">Latitude</label>
                    <input type="text" name="latitude" id="latitude" placeholder="e.g., -0.5234" value="<?php echo e($project['latitude'] ?? ''); ?>" class="block w-full rounded-lg border-gray-300 shadow-sm px-4 py-3 text-base disabled:bg-gray-100" <?php echo $is_disabled; ?>>
                </div>
                 <div>
                    <label for="longitude" class="block text-sm font-bold text-brand-blue mb-1">Longitude</label>
                    <input type="text" name="longitude" id="longitude" placeholder="e.g., 34.4590" value="<?php echo e($project['longitude'] ?? ''); ?>" class="block w-full rounded-lg border-gray-300 shadow-sm px-4 py-3 text-base disabled:bg-gray-100" <?php echo $is_disabled; ?>>
                </div>
            </div>
        </fieldset>

        <fieldset class="p-6 border border-gray-200 rounded-lg">
            <legend class="px-2 text-lg font-semibold text-brand-orange">Status & Financials</legend>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-6 mt-4">
                 <div>
                    <label for="status" class="block text-sm font-bold text-brand-blue mb-1">Project Status</label>
                    <select name="status" id="status" class="block w-full rounded-lg border-gray-300 shadow-sm px-4 py-3 text-base disabled:bg-gray-100" <?php echo $is_disabled; ?>>
                        <option value="Planned" <?php echo (($project['status'] ?? '') == 'Planned') ? 'selected' : ''; ?>>Planned</option>
                        <option value="Ongoing" <?php echo (($project['status'] ?? '') == 'Ongoing') ? 'selected' : ''; ?>>Ongoing</option>
                        <option value="Completed" <?php echo (($project['status'] ?? '') == 'Completed') ? 'selected' : ''; ?>>Completed</option>
                        <option value="Stalled" <?php echo (($project['status'] ?? '') == 'Stalled') ? 'selected' : ''; ?>>Stalled</option>
                    </select>
                </div>
                <div>
                    <label for="contractor_name" class="block text-sm font-bold text-brand-blue mb-1">Contractor Name</label>
                    <input type="text" name="contractor_name" id="contractor_name" value="<?php echo e($project['contractor_name'] ?? ''); ?>" class="block w-full rounded-lg border-gray-300 shadow-sm px-4 py-3 text-base disabled:bg-gray-100" <?php echo $is_disabled; ?>>
                </div>
                <div>
                    <label for="budget_allocated" class="block text-sm font-bold text-brand-blue mb-1">Budget Allocated (KES)</label>
                    <input type="number" name="budget_allocated" id="budget_allocated" step="0.01" value="<?php echo e($project['budget_allocated'] ?? ''); ?>" class="block w-full rounded-lg border-gray-300 shadow-sm px-4 py-3 text-base disabled:bg-gray-100" <?php echo $is_disabled; ?>>
                </div>
                <div>
                    <label for="budget_spent" class="block text-sm font-bold text-brand-blue mb-1">Budget Spent (KES)</label>
                    <input type="number" name="budget_spent" id="budget_spent" step="0.01" value="<?php echo e($project['budget_spent'] ?? ''); ?>" class="block w-full rounded-lg border-gray-300 shadow-sm px-4 py-3 text-base disabled:bg-gray-100" <?php echo $is_disabled; ?>>
                </div>
            </div>
        </fieldset>
        
        <div class="mt-8 flex justify-end items-center space-x-4">
            <a href="dashboard.php" class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50">Back to Dashboard</a>
            
            <?php if ($user_can_approve && isset($project['is_approved']) && $project['is_approved'] == 0): ?>
            <button type="submit" name="approve_project" class="inline-flex justify-center rounded-md border border-transparent bg-green-600 py-2 px-4 text-sm font-medium text-white shadow-sm hover:bg-green-700">Approve Project</button>
            <?php endif; ?>

            <?php if ($can_edit): ?>
            <button type="submit" name="save_details" class="inline-flex justify-center rounded-md border border-transparent bg-brand-orange py-2 px-4 text-sm font-medium text-white shadow-sm hover:bg-orange-600">
                <?php echo $is_edit_mode ? 'Save Changes' : 'Submit for Approval'; ?>
            </button>
            <?php endif; ?>
        </div>
    </form>
</div>
