<?php
// FILE: admin/delete_photo.php
// PURPOSE: Handles the deletion of a single project photo.

require_once 'functions.php';
require_once 'db.php';

// Ensure user is logged in
require_login();

// Check if photo ID and project ID are provided
if (!isset($_GET['id']) || empty($_GET['id']) || !isset($_GET['project_id']) || empty($_GET['project_id'])) {
    header("location: dashboard.php");
    exit;
}

$photo_id = $_GET['id'];
$project_id = $_GET['project_id']; // For redirecting back

try {
    $pdo->beginTransaction(); // Start transaction

    // --- Fetch photo details for security check and filename ---
    $sql = "SELECT pp.image_url, p.ward_id 
            FROM project_photos pp
            JOIN projects p ON pp.project_id = p.id
            WHERE pp.id = :photo_id";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['photo_id' => $photo_id]);
    $photo_info = $stmt->fetch();

    if (!$photo_info) {
        // Photo not found
        header("location: manage_project.php?id=" . $project_id);
        exit;
    }

    // Security check: WardAdmins can only delete photos from their own projects.
    if (!is_super_admin() && $photo_info['ward_id'] != $_SESSION['ward_id']) {
        // Unauthorized attempt
        header("location: dashboard.php");
        exit;
    }

    // --- Delete from Database ---
    $delete_stmt = $pdo->prepare("DELETE FROM project_photos WHERE id = :id");
    $delete_stmt->execute(['id' => $photo_id]);

    // --- Delete File from Server ---
    $file_path = 'uploads/' . $photo_info['image_url'];
    if (file_exists($file_path)) {
        @unlink($file_path);
    }
    
    $pdo->commit(); // Commit transaction

} catch (PDOException $e) {
    $pdo->rollBack();
    // Redirect back with an error (optional)
    header("location: manage_project.php?id=" . $project_id . "&error=photo_delete_failed");
    exit;
}

// Redirect back to the manage project page on success
header("location: manage_project.php?id=" . $project_id . "&success=photo_deleted#tab-photos");
exit;
